#ifndef __CPrecisionTimer__
#define __CPrecisionTimer__

#include "../Basics/CCountedObject.hpp"

namespace Exponent
{
	namespace Testing
	{
		/**
		 * @class CPrecisionTimer CPrecisionTimer.hpp
		 * @brief Provides a high accuracy timer for measuring process block CPU usage
		 *
		 * @date 14/10/2005
		 * @author Paul Chana
		 * @version 1.0.0 Initial version
		 *
		 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
		 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
		 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
		 * All content is the Intellectual property of Exp Digital Uk.\n
		 * Certain sections of this code may come from other sources. They are credited where applicable.\n
		 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
		 *
		 * $Id: CPrecisionTimer.hpp,v 1.2 2007/02/08 21:06:44 paul Exp $
		 */
		class CPrecisionTimer
		{
		public:

//	===========================================================================
			/**
    		 * Construction
    		 */
			CPrecisionTimer();

			/**
			 * Destruction
			 */
			virtual ~CPrecisionTimer();

			/**
			 * Call this to start timing at the beginning of your process block
			 */
			void startTimer();

			/**
			 * Get the elapsed time since timer started in seconds
			 * @retval double The elapsed time in seconds
			 */
			double getProcessorTime();

			/**
			 * Get the % of CPU being used by a function
			 * @param numberOfSamples The number of samples processed
			 * @retval double The % of CPU being used (0 : 1)
			 */
			double getCPUUsage(const long numberOfSamples);

			/**
			 * Set the sample rate of the system
			 * @param sampleRate the samplerate to use
			 */
			void setSampleRate(const double sampleRate) { m_sampleRate = sampleRate; }

			/**
			 * Intialise - Call this once per aplication instance
			 */
			static void initialise();

//	===========================================================================

		protected:

//	===========================================================================

			static bool CPRECISION_TIMER_INITIALISED;			/**< Are we initialised */
			static double CPRECISION_TIMER_INV_FREQUENCY;		/**< Sampling frequency */

//	===========================================================================

			uint64 m_counter;									/**< Timer count */
			double m_sampleRate;								/**< Samplerate of the signal */

//	===========================================================================

		};
	}
}
#endif	// End of CPrecisionTimer.hpp